/*****************************************************************************
**+------------------------------------------------------------------------+**
**|                                                                        |**
**|                Copyright 2010 Mistral Solutions Pvt Ltd.               |**
**|                                                                        |**
**|                                                                        |**
**|                                                                        |**   
**| This program is free software; you can redistribute it and/or          |**
**| modify it under the terms of the GNU General Public License as         |**
**| published by the Free Software Foundation; either version 2 of         |**
**| the License, or (at your option) any later version.                    |**
**|                                                                        |**
**| This program is distributed in the hope that it will be useful,        |**
**| but WITHOUT ANY WARRANTY; without even the implied warranty of         |**
**| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the           |**
**| GNU General Public License for more details.                           |**
**|                                                                        |**      
**| You should have received a copy of the GNU General Public License      |**
**| along with this program; if not, write to the Free Software            |**
**| Foundation, Inc., 59 Temple Place, Suite 330, Boston,                  |**
**| MA 02111-1307 USA                                                      |**
**+------------------------------------------------------------------------+**
*****************************************************************************/    

/**
 * \file    pmic_probe.c
 *
 * \brief   Routine to probe all I2C devices on the bus
 *
 * This file contains the generic routines for probing the I2C devices
 * on the EVM on a specific bus instance.
 *
 * \author  0043
 *
 * \version 01a,13aug,2010 Created
 */

/*
 *====================
 * Includes
 *====================
 */
#include "DM814x_EVM.h"
#include "DM814x_types.h"
#include "stdio.h"
#include "stdlib.h"

#include "DM814x_i2c.h"

/* ------------------------------------------------------------------------ *
 *                                                                          *
 *  Testing Function                                                        *
 *                                                                          *
 * ------------------------------------------------------------------------ */
void TEST_execute( STATUS ( *funchandle )( void), char *testname, INT16 testid )
{
    STATUS status = SUCCESS;

    /* Display test ID */
    printf( "%02d  Testing %s...\n", testid, testname );

    /* Call test function */
    if (testid)
        status = funchandle();
    else
        status = funchandle();	    

    /* Check for test fail */
    if ( status != 0 )
    {
        /* Print error message */
        printf( "     Please manually verify the list of I2C devices on I2C\r\n");
    }
    else
    {
        /* Print error message */
        printf( "    PASS\n" );
    }
}
/** **************************************************************************
 * \n \brief Routine to Probe slave devices on the I2C bus 
 *
 * This routine probes all the slave devices on I2C0 bus and prints the addresses 
 * of the slave devices.Uncommenting probes slave devices of all I2C bus.
 *
 * 
 *
 * \return
 * \n      return SUCCESS for success  - Description
 * \n      return FAILED for error   - Description
 */
STATUS pmic_i2c_probe (void)
{
	STATUS u32RetVal = SUCCESS;
	UINT8  u8SlaveAddr = 0x00;
	
    DM814xI2cInit( 0 );

    DM814xI2cInit( 2 );
#if 0
    DM814xI2cInit( 2 );
    DM814xI2cInit( 3 );
#endif 
	
	printf ("Probing the I2C 0.\r\n");
	for (u8SlaveAddr = 0x0; u8SlaveAddr < 128; u8SlaveAddr++)
	{
		u32RetVal = DM814xI2cProbe (0,u8SlaveAddr);
		
		if (u32RetVal == SUCCESS)
			printf ("Successfully found a device at address 0x%0x.\r\n", u8SlaveAddr);
	}


	printf ("Probing the I2C 2.\r\n");
	for (u8SlaveAddr = 0x0; u8SlaveAddr < 128; u8SlaveAddr++)
	{
		u32RetVal = DM814xI2cProbe (2,u8SlaveAddr);
		
		if (u32RetVal == SUCCESS)
			printf ("Successfully found a device at address 0x%0x.\r\n", u8SlaveAddr);
	}

#if 0

	printf ("Probing the I2C 2.\r\n");
	for (u8SlaveAddr = 0x0; u8SlaveAddr < 128; u8SlaveAddr++)
	{
		u32RetVal = DM814xI2cProbe (2,u8SlaveAddr);
		
		if (u32RetVal == SUCCESS)
			printf ("Successfully found a device at address 0x%0x.\r\n", u8SlaveAddr);
	}

	printf ("Probing the I2C 3.\r\n");
	for (u8SlaveAddr = 0x0; u8SlaveAddr < 128; u8SlaveAddr++)
	{
		u32RetVal = DM814xI2cProbe (3,u8SlaveAddr);
		
		if (u32RetVal == SUCCESS)
			printf ("Successfully found a device at address 0x%0x.\r\n", u8SlaveAddr);
	}
#endif		
	
	return (u32RetVal);
}

/* ------------------------------------------------------------------------ *
 *                                                                          *
 *  main( )                                                                 *
 *                                                                          *
 * ------------------------------------------------------------------------ */
void main(void)
{

    /* Initialize EVM */
	DM814x_EVM_Init ();

	//TEST_execute( eeprom_test,  "I2C EEPROM", (INT16)0 );
	TEST_execute( pmic_i2c_probe,  "I2C[0] Bus probe", (INT16)0 );

    printf( "\n***ALL Tests Done***\n" );
}
